MissionsExpanded = {};

--------------------------------------------------optional edit here--------------------------------------------------
--MissionsExpanded.timeValues = {	
--	--! Attention ! Missions will then remain in the task list longer
--	--MAX + 6 DAYS--
--	FIELD_SIZE_SMALL = {0,0,true}; 
--	FIELD_SIZE_BIGSMALL = {4,1,true}; --{field area size,default end day + 1 days,deactivated time missions is field area size >= field area then set *false*} 
--	FIELD_SIZE_MEDIUM = {9,2,true}; 
--	FIELD_SIZE_LARGE = {15,4,true}; 
--	FIELD_SIZE_BIGLARGE = {25,6,false};
--	TIMEMISSIONS = true; --deactivated all time missions set *false*
--};

MissionsExpanded.otherValues = {
	VEHICLE_USE_COST = 250; --200 default
	FIELD_SIZE_MEDIUM = 1.7; --1.5 default
	FIELD_SIZE_LARGE = 4; --5 default	
	MISSION_GENERATION_INTERVAL = 180000; --360000 default ~60 min
	MAX_MISSIONS = 100; --30 default
	MAX_MISSIONS_PER_FARM = 5; --3 default (! FS25_MultipleMissions Mod or other Mods !)
	MIN_REWARD = 3000; --set min reward for a mission
	SMALL_FIELDBONUS = 2000; --set bonus for a small field, is area < SMALL_FIELD
	SMALL_FIELD = 1.7;	
};
	
MissionsExpanded.missionsMultiplier = {
	--bsp.: {3,1.5} 3 max drop mission,2200x1 new = 2200x1.5 = 3300
	baleMission = {3,1.8}; --3,2200	default
	fertilizeMission = {3,1.8};	--3,1500
	hebicideMission = {2,1.8}; --2,1500
	plowMission = {3,1.3}; --2,2800
	sowMission = {5,1.5}; --5,2000
	weedMission = {2,2}; --2,2200
	cultivateMission = {3,1.2};	--3,2300
	mowMission = {3,1.2}; --3,2500 -can collect grass for missions (activated)
	tedderMission = {2,1.5}; --2,1500
	stonePickMission = {1,2}; --1,2500
	hoeMission = {2,2}; --2,1500
	baleWrapMission = {2,1.8}; --2,300 -rewardPerBale 
	----
	harvestMission = {15,1.6}; --10,2500 -can collect straw for missions (activated)	
	----
	deadwoodMission = {1,3.5,0.5}; --1,150,2000(penatly) -rewardPerTree
	treeTransportMission = {1,1.5,0.7}; --1,550,2000 -rewardPerTree
	destructibleRockMission = {1,2.5,0.7}; --1,550,1000 -rewardPerRock
	--by mods--
	limeMission = {4,2.5}; 
	mowbaleMission = {4,2.5};
	kommunalMission = {2,2.7};
	irrigationMission = {2,2.5}; 
	rollerMission = {3,1.5};
	chaffMission = {2,1.6};
	waterMission = {4,1.6};
	mulcherMission = {3,1.6};
};

MissionsExpanded.missionsFruitMultiplier = {
	--what do you keep about (harvest missions), default all 1
	others = 1.5;
	POTATO = 2;
	SUGARBEET = 2;
	SUGARCANE = 4.5;
	OLIVE = 2;
	GRAPE = 2;
	COTTON = 1.8;	
	CHAFF = 1.6;
	WHEAT = 1.4;
	BARLEY = 1.4;
	OAT = 1.4;
	CANOLA = 1.7;	
	SUNFLOWER = 1.7;
	SORGHUM = 1.7;
	SOYBEAN = 1.7;
	MAIZE = 1.9;
	GREENBEAN = 2;
	PEA = 2;
	BEETROOT = 2;
	CARROT = 2;
	PARSNIP = 2;
	SPINACH = 3;
	RICE = 1.7;
	RICELONGGRAIN = 1.7;	
	CHOPPEDMAIZE = 1.7;
};

MissionsExpanded.workAreaType = { 
	COMBINESWATH = true; --Bsp. vehicleType
	FORAGEWAGON = true;
	WINDROWER = true;
	BALER = true;
	PELLETIZER = true; --ls22 mod
	--new ls25--	
	COMBINECHOPPER = true; 
	MOWER = true;
	STONEPICKER = true;
	CUTTER = true;
	TEDDER = true;
	WORKER = true;	
	FRUITPREPARER = true;
	HARVESTER = true;
	HAULMDROP = true;
	AUXILIARY = true;
	DEFAULT = true;
	MULCHER = true;
	--trees that disturb
	STUMPCUTTER = true;
	WOODCRUSHER = true; --mod
	FORESTRYMULCHER = true; --mod
}
--------------------------------------------------optional edit here--------------------------------------------------









MissionsExpanded.workAreaTypes = {};

MissionsExpanded.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "Missions Expanded",
	notes = "Dieser Mod setzt neue Balance bei Missionen und kleinen Feldern oder unter 2500 Belohnung, zusätzlich kann man beim Mähen und Ernten das Streu/Gras einsammeln als Bonus + etc.",
	author = "(by HappyLooser)",
	version = "1.0.0.2",	
	build = 16,
	datum = "14.02.2022",
	update = "21.06.2025",
	debugPrint = false, --print ls25 types
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};	

function MissionsExpanded:loadMap(name)
	print("---loading ".. tostring(MissionsExpanded.metadata.title).. " ".. tostring(MissionsExpanded.metadata.version).. "(#".. tostring(MissionsExpanded.metadata.build).. ") ".. tostring(MissionsExpanded.metadata.author).. "---")	
	MissionsExpanded.sugarcrane = 0;
	MissionsExpanded.lastPeriode = 0;
	MissionsExpanded:loadMissionsReward(1);	
	MissionsExpanded.lastPlayerFarmId = nil;
	MissionsExpanded.checkPlacebles = true;	
	Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, MissionsExpanded.onStartMission);	
end; 

function MissionsExpanded:onStartMission()
	MissionsExpanded:placeable();	
	MissionsExpanded:loadMissionsReward(2);
	if MissionsExpanded.checkPlacebles then MissionsExpanded:replacePlacebles();end;
	MissionsExpanded:setWorkAreaTypes();
	if g_dedicatedServer == nil then
		MissionsExpanded.lastPlayerFarmId = g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId;	
	end;
end;

function MissionsExpanded:update(dt)
	if MissionsExpanded.checkPlacebles then MissionsExpanded:replacePlacebles();end;
	if g_dedicatedServer == nil then
		--MissionsExpanded:setMissionFieldBlinking(); --convert later to ls25, new Hotspot System ! needs ?? !
	end;	
end;

---------------------------------------------------------------------------------------------
function MissionsExpanded:setWorkAreaTypes()
	for typ, index in pairs (WorkAreaType) do
		if MissionsExpanded.workAreaType[typ] ~= nil and MissionsExpanded.workAreaType[typ] then 
			MissionsExpanded.workAreaTypes[index] = true;			
		end;
		if MissionsExpanded.metadata.debugPrint then print("typ and index ...".. tostring(typ).. " ----- ".. tostring(index));end;
	end;	
end;

function MissionsExpanded:getWorkAreaTypes(workAreaType)
	return MissionsExpanded.workAreaTypes[workAreaType] ~= nil and MissionsExpanded.workAreaTypes[workAreaType];
end;

function MissionsExpanded:isActiveMission(mission, farmId)
	return mission ~= nil and mission.farmId == farmId;
end;

function MissionsExpanded:placeable()   
	MissionsExpandedOldUnloadingStation = UnloadingStation.load;
    UnloadingStation.load = function(self, components, xmlFile, key, customEnv, i3dMappings, rootNode)
        local isOkay, result = pcall(MissionsExpandedOldUnloadingStation, self, components, xmlFile, key, customEnv, i3dMappings, rootNode)
        if isOkay and self ~= nil then			
			MissionsExpanded.checkPlacebles = true;
			return result;
        end;		
		return result;
    end;
end;

function MissionsExpanded:replacePlacebles()
	for _, unloadingStation in pairs(g_currentMission.storageSystem:getUnloadingStations()) do
		if unloadingStation.owningPlaceable ~= nil and unloadingStation.isSellingPoint and unloadingStation.allowMissions then 
			local farmId = unloadingStation.owningPlaceable:getOwnerFarmId();			
			if farmId > 0 then
				unloadingStation.allowMissions = false;				
			end;
		end;
	end;
	MissionsExpanded.checkPlacebles = false;
end;


---missions unloading stationen/productionen bei eigenen objecten deaktivieren---
function MissionsExpanded.getHighestSellPointPriceHarvest(self)
	for _, unloadingStation in pairs(self.mission.storageSystem:getUnloadingStations()) do
		if unloadingStation.owningPlaceable ~= nil and unloadingStation.isSellingPoint and unloadingStation.allowMissions then 
			local farmId = unloadingStation.owningPlaceable:getOwnerFarmId()
			--print("++++++++FarmId: ".. tostring(farmId))
			if farmId > 0 then
				unloadingStation.allowMissions = false;
				--print("++++++++Gesperrt")
			else
				--print("++++++++Frei")
			end;
		end;
	end;
	return self;
end;
---missions unloading stationen/productionen bei eigenen objecten deaktivieren--- 
--HarvestMission.getHighestSellPointPrice = Utils.prependedFunction(HarvestMission.getHighestSellPointPrice, MissionsExpanded.getHighestSellPointPriceHarvest);
---------------------------------------------------------------------------------------------
---collect straw for missions---
function MissionsExpanded:getIsMissionWorkAllowed(superFunc, farmId, x, z, workAreaType, vehicle)	
	--if g_localPlayer:getCurrentVehicle() ~= nil then print("workAreaType: ".. workAreaType);end;
	local mission = self:getMissionAtWorldPosition(x, z);
	return (MissionsExpanded:getWorkAreaTypes(workAreaType) and MissionsExpanded:isActiveMission(mission, farmId)) or (MissionsExpanded:isActiveMission(mission, farmId) and (mission:getIsWorkAllowed(farmId, x, z, workAreaType, vehicle)) and true or false) or superFunc(self, farmId, x, z, workAreaType, vehicle);	
end;
---collect straw for missions---
MissionManager.getIsMissionWorkAllowed = Utils.overwrittenFunction(MissionManager.getIsMissionWorkAllowed, MissionsExpanded.getIsMissionWorkAllowed);
function MissionsExpanded:getIsWorkAllowed(superFunc, farmId, x, z, workAreaType, vehicle)	
	local isActive = self:getIsRunning() or self:getIsFinished();
	--local isActive = MissionsExpanded:isActiveMission(self:getMissionAtWorldPosition(x, z), farmId)	
	if isActive then isActive = workAreaType == nil and true or MissionsExpanded:getWorkAreaTypes(workAreaType) or self.workAreaTypes[workAreaType];end;
	return isActive;
end;
--AbstractFieldMission.getIsWorkAllowed = Utils.overwrittenFunction(AbstractFieldMission.getIsWorkAllowed, MissionsExpanded.getIsWorkAllowed);
---------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------
---time missions by Mod MissionsTimes---

---time missions by Mod MissionsTimes---
---------------------------------------------------------------------------------------------
function MissionsExpanded:calculateNewReward(superFunc)
	local fruitMultiplier = 1;
	if self.field.fruitType ~= nil then
		local fruitDesc = g_fruitTypeManager:getFruitTypeByIndex(self.field.fruitType);
		if fruitDesc ~= nil then
			fruitMultiplier = fruitDesc.missionMultiplier;
		end;
	end;
	-- Less on harder modes. 1.2, 1.1, 1.0
    local difficultyMultiplier = 1.3 - 0.1 * g_currentMission.missionInfo.economicDifficulty
    local area = self.field:getAreaHa()
	
    local base = AbstractFieldMission:superClass().getReward(self)
    local rewardPerHa = self:getRewardPerHa()
    local reward = rewardPerHa * area * fruitMultiplier
	local smallBonus = 0;
	local multi = 1.2;
	if area < MissionsExpanded.otherValues.SMALL_FIELD then smallBonus = MissionsExpanded.otherValues.SMALL_FIELDBONUS;end;
	local multiReward = base + (reward*difficultyMultiplier);	
	local newReward = multiReward;
	while newReward < MissionsExpanded.otherValues.MIN_REWARD do
		newReward = newReward*multi;		
		multi = multi+0.1;
	end;
    return newReward + smallBonus;
end; 
---more Reward for missions,min xxxx + Bonus for Small Fields---
AbstractFieldMission.getReward = Utils.overwrittenFunction(AbstractFieldMission.getReward, MissionsExpanded.calculateNewReward);
---------------------------------------------------------------------------------------------

function MissionsExpanded:loadMissionsReward(int)	
	if int == 1 then
		AbstractMission.VEHICLE_USE_COST = MissionsExpanded.otherValues.VEHICLE_USE_COST;
		AbstractFieldMission.FIELD_SIZE_MEDIUM = MissionsExpanded.otherValues.FIELD_SIZE_MEDIUM;
		AbstractFieldMission.FIELD_SIZE_LARGE = MissionsExpanded.otherValues.FIELD_SIZE_LARGE;
		MissionManager.MISSION_GENERATION_INTERVAL  = MissionsExpanded.otherValues.MISSION_GENERATION_INTERVAL;
		MissionManager.MAX_MISSIONS = MissionsExpanded.otherValues.MAX_MISSIONS;
		MissionManager.MAX_MISSIONS_PER_FARM = MissionsExpanded.otherValues.MAX_MISSIONS_PER_FARM;		
		for _, fruitType in ipairs(g_fruitTypeManager:getFruitTypes()) do		
			if fruitType.name == "SUGARCANE" then MissionsExpanded.sugarcrane = fruitType.index;end;
			if not fruitType.useForFieldJob and (fruitType.name == "SUGARCANE") then			
				fruitType.useForFieldJob = true;			
			end;
			if MissionsExpanded.missionsFruitMultiplier[fruitType.name] ~= nil then
				if fruitType.missionMultiplier ~= nil then				
					if fruitType.missionMultiplier < MissionsExpanded.missionsFruitMultiplier[fruitType.name] then fruitType.missionMultiplier = MissionsExpanded.missionsFruitMultiplier[fruitType.name];end;				
				else				
					fruitType.missionMultiplier = MissionsExpanded.missionsFruitMultiplier[fruitType.name];				
				end;	
			else
				if fruitType.missionMultiplier ~= nil then				
					if fruitType.missionMultiplier < MissionsExpanded.missionsFruitMultiplier.others then fruitType.missionMultiplier = MissionsExpanded.missionsFruitMultiplier.others;end;				
				else				
					fruitType.missionMultiplier = MissionsExpanded.missionsFruitMultiplier.others;				
				end;
			end;
		end;
	elseif int == 2 then
		for index, mission in ipairs(g_missionManager.missionTypes) do
			if MissionsExpanded.missionsMultiplier[mission.name] ~= nil then
				mission.data.maxNumInstances = MissionsExpanded.missionsMultiplier[mission.name][1];				
				if mission.name == "deadwoodMission" or mission.name == "destructibleRockMission" or mission.name == "treeTransportMission" or mission.name == "baleWrapMission" then
					if mission.name == "baleWrapMission" and mission.data.rewardPerBale ~= nil then 						
						mission.data.rewardPerBale = mission.data.rewardPerBale*MissionsExpanded.missionsMultiplier[mission.name][2];
					elseif mission.name == "destructibleRockMission" and mission.data.rewardPerRock ~= nil and mission.data.penaltyPerRock ~= nil then										
						mission.data.rewardPerRock = mission.data.rewardPerRock*MissionsExpanded.missionsMultiplier[mission.name][2];
						mission.data.penaltyPerRock = mission.data.penaltyPerRock*MissionsExpanded.missionsMultiplier[mission.name][3];					
					elseif (mission.name == "deadwoodMission" or mission.name == "treeTransportMission") and mission.data.rewardPerTree ~= nil and mission.data.penaltyPerTree ~= nil then
						mission.data.rewardPerTree = mission.data.rewardPerTree*MissionsExpanded.missionsMultiplier[mission.name][2];
						mission.data.penaltyPerTree = mission.data.penaltyPerTree*MissionsExpanded.missionsMultiplier[mission.name][3];
					end;
				elseif mission.name == "kommunalMission" and mission.classObject ~= nil and mission.classObject.REWARD_PER_HA ~= nil then --mod					
					mission.classObject.REWARD_PER_HA = mission.classObject.REWARD_PER_HA*MissionsExpanded.missionsMultiplier[mission.name][2];
				elseif mission.data.rewardPerHa ~= nil then						
					mission.data.rewardPerHa = mission.data.rewardPerHa*MissionsExpanded.missionsMultiplier[mission.name][2];				
				end;				
			end;
		end;		
	end;
end;

---------------------------------------------------------------------------------------------
---ls22 mp fix set mission blinking field---
function MissionsExpanded:setMissionFieldBlinking()
	if MissionsExpanded.lastPlayerFarmId == nil or (MissionsExpanded.lastPlayerFarmId ~= g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId) then
		function createMapHotspot(sellingStation)
			if sellingStation.owningPlaceable.rootNode == nil then
				return nil;
			end;
			local x, _, z = getWorldTranslation(sellingStation.owningPlaceable.rootNode);
			local hotspot = sellingStation.mapHotspot;

			if hotspot ~= nil then
				x, z = hotspot:getWorldPosition();
			end;

			local mapHotspot = MissionHotspot.new();

			mapHotspot:setWorldPosition(x, z);
			g_currentMission:addMapHotspot(mapHotspot);
			return mapHotspot;		
		end;
		function destroyMapHotspot(mission)
			if mission.mapHotspot ~= nil then
				g_currentMission:removeMapHotspot(mission.mapHotspot);
				mission.mapHotspot:delete();

				mission.mapHotspot = nil;
			end;
		end;
		for _, mission in ipairs(g_missionManager.missions) do
			if mission.isInMissionMap and mission.field ~= nil then
				local field = g_fieldManager.fields[tonumber(mission.field:getName())];
				if field ~= nil then
					if mission.farmId == g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId then
						field.mapHotspot:setBlinking(true);
						field.mapHotspot:setPersistent(true);
					else
						field.mapHotspot:setBlinking(false);
						field.mapHotspot:setPersistent(false);
					end;
					if mission.sellPoint ~= nil then
						local sellingStation = mission.sellPoint;
						if mission.farmId == g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId then
							if mission.mapHotspot ~= nil and sellingStation.mapHotspot ~= nil and mission.status == AbstractMission.STATUS_RUNNING then
								mission.mapHotspot = createMapHotspot(sellingStation);
							end;
						else
							destroyMapHotspot(mission);
						end;
					end;
				end;
			end;
		end;
		MissionsExpanded.lastPlayerFarmId = g_currentMission.playerSystem.playersByUserId[g_currentMission.playerUserId].farmId;
	end;
end;
---ls22 mp fix set mission blinking field---
---------------------------------------------------------------------------------------------
addModEventListener(MissionsExpanded);

